/*
 * MATLAB Compiler: 3.0
 * Date: Mon Nov 03 13:00:57 2003
 * Arguments: "-B" "macro_default" "-O" "all" "-O" "fold_scalar_mxarrays:on"
 * "-O" "fold_non_scalar_mxarrays:on" "-O" "optimize_integer_for_loops:on" "-O"
 * "array_indexing:on" "-O" "optimize_conditionals:on" "-m" "-W" "main" "-L"
 * "C" "-t" "-T" "link:exe" "-h" "libmmfile.mlib" "DancingMonkeys" 
 */
#include "signal_private_check_order.h"
#include "libmatlbm.h"
static mxArray * _mxarray0_;
static mxArray * _mxarray1_;

static mxChar _array3_[31] = { 'O', 'r', 'd', 'e', 'r', ' ', 'c', 'a',
                               'n', 'n', 'o', 't', ' ', 'b', 'e', ' ',
                               'l', 'e', 's', 's', ' ', 't', 'h', 'a',
                               'n', ' ', 'z', 'e', 'r', 'o', '.' };
static mxArray * _mxarray2_;

static mxChar _array5_[34] = { 'R', 'o', 'u', 'n', 'd', 'i', 'n', 'g', ' ',
                               'o', 'r', 'd', 'e', 'r', ' ', 't', 'o', ' ',
                               'n', 'e', 'a', 'r', 'e', 's', 't', ' ', 'i',
                               'n', 't', 'e', 'g', 'e', 'r', '.' };
static mxArray * _mxarray4_;
static mxArray * _mxarray6_;

void InitializeModule_signal_private_check_order(void) {
    _mxarray0_ = mclInitializeDoubleVector(0, 0, (double *)NULL);
    _mxarray1_ = mclInitializeDouble(0.0);
    _mxarray2_ = mclInitializeString(31, _array3_);
    _mxarray4_ = mclInitializeString(34, _array5_);
    _mxarray6_ = mclInitializeDouble(1.0);
}

void TerminateModule_signal_private_check_order(void) {
    mxDestroyArray(_mxarray6_);
    mxDestroyArray(_mxarray4_);
    mxDestroyArray(_mxarray2_);
    mxDestroyArray(_mxarray1_);
    mxDestroyArray(_mxarray0_);
}

static mxArray * Msignal_private_check_order(mxArray * * w,
                                             mxArray * * trivalwin,
                                             int nargout_,
                                             mxArray * n_in);

_mexLocalFunctionTable _local_function_table_signal_private_check_order
  = { 0, (mexFunctionTableEntry *)NULL };

/*
 * The function "mlfSignal_private_check_order" contains the normal interface
 * for the "signal/private/check_order" M-function from file
 * "c:\matlab65\toolbox\signal\signal\private\check_order.m" (lines 1-35). This
 * function processes any input arguments and passes them to the implementation
 * version of the function, appearing above.
 */
mxArray * mlfSignal_private_check_order(mxArray * * w,
                                        mxArray * * trivalwin,
                                        mxArray * n_in) {
    int nargout = 1;
    mxArray * n_out = NULL;
    mxArray * w__ = NULL;
    mxArray * trivalwin__ = NULL;
    mlfEnterNewContext(2, 1, w, trivalwin, n_in);
    if (w != NULL) {
        ++nargout;
    }
    if (trivalwin != NULL) {
        ++nargout;
    }
    n_out = Msignal_private_check_order(&w__, &trivalwin__, nargout, n_in);
    mlfRestorePreviousContext(2, 1, w, trivalwin, n_in);
    if (w != NULL) {
        mclCopyOutputArg(w, w__);
    } else {
        mxDestroyArray(w__);
    }
    if (trivalwin != NULL) {
        mclCopyOutputArg(trivalwin, trivalwin__);
    } else {
        mxDestroyArray(trivalwin__);
    }
    return mlfReturnValue(n_out);
}

/*
 * The function "mlxSignal_private_check_order" contains the feval interface
 * for the "signal/private/check_order" M-function from file
 * "c:\matlab65\toolbox\signal\signal\private\check_order.m" (lines 1-35). The
 * feval function calls the implementation version of
 * signal/private/check_order through this function. This function processes
 * any input arguments and passes them to the implementation version of the
 * function, appearing above.
 */
void mlxSignal_private_check_order(int nlhs,
                                   mxArray * plhs[],
                                   int nrhs,
                                   mxArray * prhs[]) {
    mxArray * mprhs[1];
    mxArray * mplhs[3];
    int i;
    if (nlhs > 3) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: signal/private/check_order Line: 1 C"
            "olumn: 1 The function \"signal/private/check_order\" was c"
            "alled with more than the declared number of outputs (3)."),
          NULL);
    }
    if (nrhs > 1) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: signal/private/check_order Line: 1 C"
            "olumn: 1 The function \"signal/private/check_order\" was c"
            "alled with more than the declared number of inputs (1)."),
          NULL);
    }
    for (i = 0; i < 3; ++i) {
        mplhs[i] = NULL;
    }
    for (i = 0; i < 1 && i < nrhs; ++i) {
        mprhs[i] = prhs[i];
    }
    for (; i < 1; ++i) {
        mprhs[i] = NULL;
    }
    mlfEnterNewContext(0, 1, mprhs[0]);
    mplhs[0]
      = Msignal_private_check_order(&mplhs[1], &mplhs[2], nlhs, mprhs[0]);
    mlfRestorePreviousContext(0, 1, mprhs[0]);
    plhs[0] = mplhs[0];
    for (i = 1; i < 3 && i < nlhs; ++i) {
        plhs[i] = mplhs[i];
    }
    for (; i < 3; ++i) {
        mxDestroyArray(mplhs[i]);
    }
}

/*
 * The function "Msignal_private_check_order" is the implementation version of
 * the "signal/private/check_order" M-function from file
 * "c:\matlab65\toolbox\signal\signal\private\check_order.m" (lines 1-35). It
 * contains the actual compiled code for that M-function. It is a static
 * function and must only be called from one of the interface functions,
 * appearing below.
 */
/*
 * function [n_out, w, trivalwin] = check_order(n_in)
 */
static mxArray * Msignal_private_check_order(mxArray * * w,
                                             mxArray * * trivalwin,
                                             int nargout_,
                                             mxArray * n_in) {
    mexLocalFunctionTable save_local_function_table_
      = mclSetCurrentLocalFunctionTable(
          &_local_function_table_signal_private_check_order);
    mxArray * n_out = NULL;
    mxArray * ans = NULL;
    mclCopyArray(&n_in);
    /*
     * %CHECK_ORDER Checks the order passed to the window functions.
     * % [N,W,TRIVALWIN] = CHECK_ORDER(N_ESTIMATE) will round N_ESTIMATE to the
     * % nearest integer if it is not alreay an integer. In special cases (N is [],
     * % 0, or 1), TRIVALWIN will be set to flag that W has been modified.
     * 
     * %   Copyright 1988-2002 The MathWorks, Inc.
     * %   $Revision: 1.6 $  $Date: 2002/03/28 17:29:27 $
     * 
     * w = [];
     */
    mlfAssign(w, _mxarray0_);
    /*
     * trivalwin = 0;
     */
    mlfAssign(trivalwin, _mxarray1_);
    /*
     * 
     * % Special case of negative orders:
     * if n_in < 0,
     */
    if (mclLtBool(mclVa(n_in, "n_in"), _mxarray1_)) {
        /*
         * error('Order cannot be less than zero.');
         */
        mlfError(_mxarray2_, NULL);
    /*
     * end
     */
    }
    /*
     * 
     * % Check if order is already an integer or empty
     * % If not, round to nearest integer.
     * if isempty(n_in) | n_in == floor(n_in),
     */
    {
        mxArray * a_ = mclInitialize(mlfIsempty(mclVa(n_in, "n_in")));
        if (mlfTobool(a_)
            || mlfTobool(
                 mclOr(
                   a_,
                   mclEq(
                     mclVa(n_in, "n_in"), mlfFloor(mclVa(n_in, "n_in")))))) {
            mxDestroyArray(a_);
            /*
             * n_out = n_in;
             */
            mlfAssign(&n_out, mclVa(n_in, "n_in"));
        /*
         * else
         */
        } else {
            mxDestroyArray(a_);
            /*
             * n_out = round(n_in);
             */
            mlfAssign(&n_out, mlfRound(mclVa(n_in, "n_in")));
            /*
             * warning('Rounding order to nearest integer.');
             */
            mclAssignAns(&ans, mlfNWarning(0, NULL, _mxarray4_, NULL));
        }
    /*
     * end
     */
    }
    /*
     * 
     * % Special cases:
     * if isempty(n_out) | n_out == 0,
     */
    {
        mxArray * a_ = mclInitialize(mlfIsempty(mclVv(n_out, "n_out")));
        if (mlfTobool(a_)
            || mlfTobool(
                 mclOr(a_, mclEq(mclVv(n_out, "n_out"), _mxarray1_)))) {
            mxDestroyArray(a_);
            /*
             * w = zeros(0,1);               % Empty matrix: 0-by-1
             */
            mlfAssign(w, mlfZeros(_mxarray1_, _mxarray6_, NULL));
            /*
             * trivalwin = 1; 
             */
            mlfAssign(trivalwin, _mxarray6_);
        /*
         * elseif n_out == 1,
         */
        } else {
            mxDestroyArray(a_);
            if (mclEqBool(mclVv(n_out, "n_out"), _mxarray6_)) {
                /*
                 * w = 1;
                 */
                mlfAssign(w, _mxarray6_);
                /*
                 * trivalwin = 1;   
                 */
                mlfAssign(trivalwin, _mxarray6_);
            }
        }
    /*
     * end
     */
    }
    mclValidateOutput(
      n_out, 1, nargout_, "n_out", "signal/private/check_order");
    mclValidateOutput(*w, 2, nargout_, "w", "signal/private/check_order");
    mclValidateOutput(
      *trivalwin, 3, nargout_, "trivalwin", "signal/private/check_order");
    mxDestroyArray(ans);
    mxDestroyArray(n_in);
    mclSetCurrentLocalFunctionTable(save_local_function_table_);
    return n_out;
}
